<?php
/*======================================================================*\
|| #################################################################### ||
|| # Quick Account Switch  Hack for vBulletin 3.5 by Psionic Vision
|| # Back-End Administrator Interface
|| #################################################################### ||
|| # Copyright 2006 Anthony Kanevsky (ankan925@optonline.net) aka Psionic Vision. All Rights Reserved.
|| # This file may not be redistributed.
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
error_reporting(E_ALL & ~E_NOTICE);

// #############################################################################
$phrasegroups = array('user');
$specialtemplates = array();

// #############################################################################
require_once('./global.php');

// #############################################################################
print_cp_header($vbphrase['qas_qas']);

if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

################################################################################################################################
################################################################################################################################
################################################################################################################################

// handle default action
if (!isset($_REQUEST['do']))
{
	exit;
}

################################################################################################################################
################################################################################################################################
################################################################################################################################

if ($_REQUEST['do'] == 'newlink')
{
	// retrieve gpc data
	$vbulletin->input->clean_gpc('r', 'userid', TYPE_UINT);
	
	// make sure we are accessing a valid user
	$getuser = $db->query_first("
		SELECT userid, username 
		FROM " . TABLE_PREFIX . "user 
		WHERE userid = " . $vbulletin->GPC['userid'] . "
		LIMIT 1
	");
	
	if (!$getuser)
	{
		print_stop_message('could_not_find', '<b>' . $vbphrase['user'] . '</b>', $vbphrase['userid'], $vbulletin->GPC['userid']);
	}
	
	// output form header
	print_form_header('qas', 'finduser', false, true, 'cpform', '400px');
	print_table_header(construct_phrase($vbphrase['qas_find_user_to_link_to_x'], $getuser['userid'], $getuser['username']));
		
	// output the rest of the form
	construct_hidden_code('userid', $vbulletin->GPC['userid']);
	print_input_row($vbphrase['username'], 'username');
	
	// output submit row
	print_submit_row($vbphrase['submit'], '');
}

if ($_REQUEST['do'] == 'finduser')
{
	// retrieve gpc data
	$vbulletin->input->clean_array_gpc('r', array(
		'userid'		=> TYPE_UINT,
		'username'		=> TYPE_STR
	));
	
	// make sure we are accessing a valid user
	$getuser = $db->query_first("
		SELECT userid, username 
		FROM " . TABLE_PREFIX . "user 
		WHERE userid = " . $vbulletin->GPC['userid'] . "
		LIMIT 1
	");
	
	if (!$getuser)
	{
		print_stop_message('could_not_find', '<b>' . $vbphrase['user'] . '</b>', $vbphrase['userid'], $vbulletin->GPC['userid']);
	}

	// get search results
	if ($vbulletin->GPC['username'])
	{
		if ($vbulletin->GPC['username'] == '*')
		{
			$vbulletin->GPC['username'] = '';
		}
	
		$getresults = $db->query_read("
			SELECT userid, username 
			FROM " . TABLE_PREFIX . "user 
			WHERE username LIKE '%" . $db->escape_string($vbulletin->GPC['username']) . "%'
			AND username != '" . $db->escape_string($getuser['username']) . "'
		");
		
		if (!$db->num_rows($getresults))
		{
			print_stop_message('no_users_matched_your_query');
		}
	}
	else
	{
		print_stop_message('no_users_matched_your_query');
	}
	
	print_form_header('qas', 'addlink', false, true, 'cpform', '400px');
	print_table_header(construct_phrase($vbphrase['qas_search_results'], $getuser['userid'], $getuser['username']), 2);
		
	construct_hidden_code('userid', $vbulletin->GPC['userid']);
	
	while ($user = $db->fetch_array($getresults))
	{
		print_label_row(
			$user['username'],
			'<span style="float: right">' .
			construct_button_code($vbphrase['profile'], 'user.php?do=edit&amp;userid=' . $user['userid']) .
			construct_button_code($vbphrase['qas_link'], 'qas.php?do=addlink&amp;u1=' . $vbulletin->GPC['userid']  . '&amp;u2=' . $user['userid']) .
			'</span>'
		);
	}
		
	print_table_footer(2);
}

if ($_REQUEST['do'] == 'addlink')
{
	// retrieve gpc data
	$vbulletin->input->clean_array_gpc('r', array(
		'u1'		=> TYPE_UINT,
		'u2'		=> TYPE_UINT,
	));
	
	if ($vbulletin->GPC['u1'] == $vbulletin->GPC['u2'])
	{
		print_stop_message('no_users_matched_your_query');
	}
	else
	{
		$getuserinfo = $db->query_read("
			SELECT userid, username, psi_qas
			FROM " . TABLE_PREFIX . "user 
			WHERE userid = " . $vbulletin->GPC['u1'] . "
			OR userid = " . $vbulletin->GPC['u2'] . "
			LIMIT 2
		");
		
		if ($db->num_rows($getuserinfo) < 2)
		{
			print_stop_message('no_users_matched_your_query');
		}
		
		while ($user = $db->fetch_array($getuserinfo))
		{
			$user['psi_qas'] = explode(' ', $user['psi_qas']);
			$linkuserid = ($user['userid'] == $vbulletin->GPC['u1'] ? $vbulletin->GPC['u2'] : $vbulletin->GPC['u1']);
			
			if (!in_array($linkuserid, $user['psi_qas']))
			{
				$user['psi_qas'][] = $linkuserid;
			}

			$user['psi_qas'] = implode(' ', $user['psi_qas']);

			$db->query_write("
				UPDATE " . TABLE_PREFIX . "user
				SET psi_qas = '" . trim($db->escape_string($user['psi_qas'])) . "'
				WHERE userid = " . $user['userid'] . "
				LIMIT 1
			");
		}
		
		define('CP_REDIRECT', "user.php?do=edit&amp;u=" . $vbulletin->GPC['u1']);
		print_stop_message('linked_users_successfully');
	}
}

if ($_REQUEST['do'] == 'unlink')
{
	// retrieve gpc data
	$vbulletin->input->clean_array_gpc('r', array(
		'u1'		=> TYPE_UINT,
		'u2'		=> TYPE_UINT,
	));
	
	$getuserinfo = $db->query_read("
		SELECT userid, username, psi_qas
		FROM " . TABLE_PREFIX . "user 
		WHERE userid = " . $vbulletin->GPC['u1'] . "
		OR userid = " . $vbulletin->GPC['u2'] . "
		LIMIT 2
	");
		
	while ($user = $db->fetch_array($getuserinfo))
	{
		$user['psi_qas'] = explode(' ', $user['psi_qas']);
		$linkuserid = ($user['userid'] == $vbulletin->GPC['u1'] ? $vbulletin->GPC['u2'] : $vbulletin->GPC['u1']);
			
		foreach ($user['psi_qas'] as $key => $value)
		{
			if ($value == $linkuserid)
			{
				unset($user['psi_qas'][$key]);
			}
		}
			
		$user['psi_qas'] = implode(' ', $user['psi_qas']);
			
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "user
			SET psi_qas = '" . trim($db->escape_string($user['psi_qas'])) . "'
			WHERE userid = " . $user['userid'] . "
			LIMIT 1
		");
	}
		
	define('CP_REDIRECT', "user.php?do=edit&amp;u=" . $vbulletin->GPC['u1']);
	print_stop_message('unlinked_users_successfully');
}

################################################################################################################################
################################################################################################################################
################################################################################################################################

print_cp_footer();

/*======================================================================*\
|| #################################################################### ||
|| # Quick Account Switch  Hack for vBulletin 3.5 by Psionic Vision
|| #################################################################### ||
\*======================================================================*/
?>
